<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PelangganController;
use App\Http\Controllers\PembayaranController;
use App\Http\Controllers\JadwalTeknisiController;
use App\Http\Controllers\GrubController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Auth\RegisteredUserController;

// Route pembayaran bayar untuk admin & penagihan
Route::middleware(['role:admin|penagihan'])->group(function() {
    Route::post('pembayaran/bayar/{id}', [PembayaranController::class, 'bayar'])->name('pembayaran.bayar.submit');
});

// Route untuk admin
Route::middleware(['role:admin'])->group(function() {
    // CRUD pelanggan
    Route::resource('pelanggan', PelangganController::class);
    Route::resource('grubs', GrubController::class);

    // suspen pelanggan 
    Route::post('/pelanggan/{id}/suspend', [PelangganController::class, 'suspend'])->name('pelanggan.suspend');
    Route::post('/pelanggan/{id}/aktifkan', [PelangganController::class, 'aktifkan'])->name('pelanggan.aktifkan');

    // Cek semua tagihan pelanggan tertentu
    Route::get('pelanggan/{pelanggan}/tagihan', [PelangganController::class, 'tagihan'])->name('pelanggan.tagihan');

    // Cek tagihan pelanggan yang belum lunas
    Route::get('pelanggan/{pelanggan}/tagihan-belum-lunas', [PelangganController::class, 'tagihanBelumLunas'])->name('pelanggan.tagihan_belum_lunas');

    // Jadwal teknisi & pembayaran (admin)
    Route::get('jadwal-teknisi/autocomplete-teknisi', [JadwalTeknisiController::class, 'autocompleteTeknisi'])->name('jadwal-teknisi.autocomplete-teknisi');
    Route::get('jadwal-teknisi/autocomplete-lokasi', [JadwalTeknisiController::class, 'autocompleteLokasi'])->name('jadwal-teknisi.autocomplete-lokasi');
    Route::resource('jadwal-teknisi', JadwalTeknisiController::class);

    // Resource pembayaran untuk admin (kecuali index & show)
    Route::post('/pembayaran/{id}/cicil', [PelangganController::class, 'bayarCicilan'])->name('pembayaran.cicil');
    Route::resource('pembayaran', PembayaranController::class)->except(['index', 'show']);
    Route::get('pembayaran/generate-tagihan', [PembayaranController::class, 'generateTagihan'])->name('pembayaran.generate_tagihan');

    // USER MANAGEMENT (fitur tambah, list, edit, hapus user)
    Route::get('users', [UserController::class, 'index'])->name('users.index');
    Route::get('users/{id}/edit', [UserController::class, 'edit'])->name('users.edit');
    Route::put('users/{id}', [UserController::class, 'update'])->name('users.update');
    Route::delete('users/{id}', [UserController::class, 'destroy'])->name('users.destroy');

    // REGISTER USER (khusus admin)
    Route::get('register', [RegisteredUserController::class, 'create'])->name('register.create');
    Route::post('register', [RegisteredUserController::class, 'store'])->name('register.store');
});

// Route untuk penagihan
Route::middleware(['role:penagihan'])->group(function() {
    Route::get('pembayaran', [PembayaranController::class, 'index'])->name('pembayaran.index');
    Route::post('pembayaran/{id}/validasi', [PembayaranController::class, 'validasi']);
});

// Route untuk teknisi
Route::middleware(['role:teknisi'])->group(function() {
    Route::get('jadwal-saya', [JadwalTeknisiController::class, 'jadwalSaya'])->name('jadwal-saya');
});

// Route feedback jadwal teknisi untuk admin dan teknisi (gabungan)
Route::middleware(['role:admin|teknisi'])->group(function() {
    Route::post('jadwal-teknisi/{id}/feedback', [JadwalTeknisiController::class, 'feedback'])->name('jadwal-teknisi.feedback');
});

// Route default dan profile
Route::get('/', function () {
    return redirect('/login');
});
Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';